﻿# Load WinSCP .NET assembly
Add-Type -Path "C:\Path\To\WinSCPnet.dll"

# Set up session options
$sessionOptions = New-Object WinSCP.SessionOptions -Property @{
    Protocol = [WinSCP.Protocol]::Sftp
    HostName = "your_sftp_server"
    UserName = "your_username"
    Password = "your_password"
    SshHostKeyFingerprint = "your_ssh_host_key"
}

# Connect to the SFTP server
$session = New-Object WinSCP.Session
$session.Open($sessionOptions)

# Remote directory containing the files
$remotePath = "/remote/path/to/files"

# Local directory for storing the downloaded files
$localPath = "C:\local\path\for\downloads"

# Remote directory for archiving files
$archivePath = "/remote/path/to/archive/folder"

# Get all the files in the remote directory
$files = $session.EnumerateRemoteFiles($remotePath, $mask, [WinSCP.EnumerationOptions]::AllDirectories)

# Download all the files
foreach ($file in $files)
{
    Write-Host "Downloading $($file.FullName) ..."
    $filePath = [WinSCP.RemotePath]::EscapeFileMask($file.FullName)
    $session.GetFiles($filePath, $localPath + "\*").Check()
    $session.MoveFile($filePath, $archivePath + "/")
}
