﻿# Load WinSCP .NET assembly
Add-Type -Path "C:\Path\To\WinSCPnet.dll"

# Set up session options
$sessionOptions = New-Object WinSCP.SessionOptions -Property @{
    Protocol = [WinSCP.Protocol]::Sftp
    HostName = "your_sftp_server"
    UserName = "your_username"
    Password = "your_password"
    SshHostKeyFingerprint = "your_ssh_host_key"
}

# Connect to the SFTP server
$session = New-Object WinSCP.Session
$session.Open($sessionOptions)

# Remote directory containing the files
$remotePath = "/remote/path/to/files"

# Local directory for storing the local files to be uploaded
$localPath = "C:\local\path\for\downloads"

# Local directory for archiving files
$archivePath = "C:\local\path\for\archive"

# Get all the files in the local directory
$files = Get-ChildItem $localPath

# Upload all the files
foreach ($file in $files)
{
    $filePath = $file.FullName
    Write-Host "Uploading $($filePath) ..."
    
    $session.PutFiles($filePath, $remotePath + "/").Check()
    Move-Item -Path $filePath -Destination $archivePath
}
